/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.mixer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllRecipeSerializers;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.content.processing.basin.BasinInput;
import com.zurrtum.create.content.processing.basin.BasinRecipe;
import com.zurrtum.create.content.processing.recipe.HeatCondition;
import com.zurrtum.create.content.processing.recipe.ProcessingOutput;
import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import java.util.ArrayDeque;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record CompactingRecipe(List<ProcessingOutput> results, HeatCondition heat, List<FluidIngredient> fluidIngredients, List<SizedIngredient> ingredients) implements BasinRecipe
{
    @Override
    public int getIngredientSize() {
        return this.fluidIngredients.size() + this.ingredients.size();
    }

    public boolean matches(BasinInput input, class_1937 world) {
        if (!this.heat.testBlazeBurner(input.heat())) {
            return false;
        }
        ServerFilteringBehaviour filter = input.filter();
        if (filter == null) {
            return false;
        }
        if (!filter.test(this.results.getFirst().create())) {
            return false;
        }
        List<class_1799> outputs = BasinRecipe.tryCraft(input, this.ingredients);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.matchFluidIngredient(input, this.fluidIngredients)) {
            return false;
        }
        ProcessingOutput.rollOutput(input.random(), this.results, outputs::add);
        return input.acceptOutputs(outputs, List.of(), true);
    }

    @Override
    public boolean apply(BasinInput input) {
        if (!this.heat.testBlazeBurner(input.heat())) {
            return false;
        }
        ArrayDeque<Runnable> changes = new ArrayDeque<Runnable>();
        List<class_1799> outputs = BasinRecipe.prepareCraft(input, this.ingredients, changes);
        if (outputs == null) {
            return false;
        }
        if (!BasinRecipe.prepareFluidCraft(input, this.fluidIngredients, changes)) {
            return false;
        }
        ProcessingOutput.rollOutput(input.random(), this.results, outputs::add);
        if (!input.acceptOutputs(outputs, List.of(), true)) {
            return false;
        }
        changes.forEach(Runnable::run);
        return input.acceptOutputs(outputs, List.of(), false);
    }

    public class_1865<CompactingRecipe> method_8119() {
        return AllRecipeSerializers.COMPACTING;
    }

    public class_3956<CompactingRecipe> method_17716() {
        return AllRecipeTypes.COMPACTING;
    }

    public static class Serializer
    implements class_1865<CompactingRecipe> {
        public static final MapCodec<CompactingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ProcessingOutput.CODEC.listOf(1, 4).fieldOf("results").forGetter(CompactingRecipe::results), (App)HeatCondition.CODEC.optionalFieldOf("heat_requirement", (Object)HeatCondition.NONE).forGetter(CompactingRecipe::heat), (App)FluidIngredient.CODEC.listOf(1, 2).optionalFieldOf("fluid_ingredients", List.of()).forGetter(CompactingRecipe::fluidIngredients), (App)SizedIngredient.LIST_CODEC.optionalFieldOf("ingredients", List.of()).forGetter(CompactingRecipe::ingredients)).apply((Applicative)instance, CompactingRecipe::new)).validate(recipe -> {
            if (recipe.fluidIngredients.isEmpty() && recipe.ingredients.isEmpty()) {
                return DataResult.error(() -> "CompactingRecipe must have a ingredient or a fluid ingredient");
            }
            if (recipe.ingredients.size() > 9) {
                return DataResult.error(() -> "Ingredients type is too many: " + recipe.ingredients.size() + ", expected range [0-9]");
            }
            return DataResult.success((Object)recipe);
        });
        public static final class_9139<class_9129, CompactingRecipe> PACKET_CODEC = class_9139.method_56905((class_9139)ProcessingOutput.STREAM_CODEC.method_56433(class_9135.method_56363()), CompactingRecipe::results, HeatCondition.PACKET_CODEC, CompactingRecipe::heat, (class_9139)FluidIngredient.PACKET_CODEC.method_56433(class_9135.method_56363()), CompactingRecipe::fluidIngredients, (class_9139)SizedIngredient.PACKET_CODEC.method_56433(class_9135.method_56363()), CompactingRecipe::ingredients, CompactingRecipe::new);

        public MapCodec<CompactingRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, CompactingRecipe> method_56104() {
            return PACKET_CODEC;
        }
    }
}

